//
//  NSBezierPath+Additons.h
//  PlateControl
//
//  Created by Andreas on Sun Jan 18 2004.
//  Copyright (c) 2004 Andreas Mayer. All rights reserved.
//
//	2005-05-23	Andreas Mayer
//	- added -appendBezierPathWithTriangleInRect:orientation: and +bezierPathWithTriangleInRect:orientation:

#import <AppKit/AppKit.h>

typedef NS_ENUM(uint8_t, AMTriangleOrientation) {
	AMTriangleUp = 0,
	AMTriangleDown,
	AMTriangleLeft,
	AMTriangleRight
};

typedef NS_ENUM(uint8_t, INLineArrowStyle) {
	INArrowStyle = 0,
	INCircleStyle,
	INOpenArrowStyle,
	INDiamondStyle,
	INPointYArrowStyle,
};

#ifndef NSBezierPathElementQuadraticCurveTo
#define NSBezierPathElementQuadraticCurveTo 4
#endif

@interface NSBezierPath (AMAdditions)
+ (NSBezierPath *)bezierPathWithDiamondInRect:(NSRect)rect;

+ (NSBezierPath *)bezierPathWithPlateInRect:(NSRect)rect;

- (void)appendBezierPathWithPlateInRect:(NSRect)rect;

+ (NSBezierPath *)bezierPathWithRoundedRect:(NSRect)rect cornerRadius:(CGFloat)radius;

+ (NSBezierPath *)bezierPathWithTopRoundedRect:(NSRect)rect radius:(CGFloat)radius;

+ (NSBezierPath *)bezierPathWithRect:(NSRect)rect roundNE:(BOOL)roundNE roundSE:(BOOL)roundSE roundSW:(BOOL)roundSW roundNW:(BOOL)roundNW radius:(CGFloat)radius;

#if 0
+ (NSBezierPath *)bezierPathWithBottomRoundedRect:(NSRect)rect radius:(CGFloat)radius;
#endif

+ (NSBezierPath *)bezierPathWithTriangleInRect:(NSRect)rect orientation:(AMTriangleOrientation)orientation;

- (void)appendBezierPathWithTriangleInRect:(NSRect)rect orientation:(AMTriangleOrientation)orientation;

+ (NSBezierPath *)bezierPathWithLineArrowHeadOfStartPoint:(NSPoint)startPoint endPoint:(NSPoint)endPoint headLineStyle:(INLineArrowStyle)lineHeadStyle width:(float)width length:(float)length;

- (void)strokeInside;

- (void)strokeInsideWithinRect:(NSRect)clipRect;

- (CGPathRef)quartzPath __attribute__((cf_returns_retained));

+ (NSBezierPath *)bezierPathHandlesForCubicSegment:(NSPoint *)segment handleSize:(CGFloat)handleSize;

- (BOOL)isFirstSubpathClockwise;

@end
